import math
import numpy as np
from decimal import Decimal as D, getcontext
import matplotlib.pyplot as plt
from scipy.interpolate import make_interp_spline
precision = 250
getcontext().prec = precision
print_work = False
do_filler = False
alphabet = list("abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ!£$%^&*()+-=[]{},.?@;:|\<>/#~¬áéíóú§αβΓγΔδεζηΘθΙικΛλμνΞξΠπρΣσςτΥυΦφχΨψΩωБГДЖИиЙйЛПЦЧШЩЪъЬьЮюЯяㄱㄴㄷㄹㅁㅂㅅㅇㅈㅊㅋㅌㅍㅎㅏㅑㅓㅕㅗㅛㅜㅠㅡㅣбґтф᐀ᐁᐂᐃᐄᐅᐆᐇᐈᐉᐊᐋᐌᐍᐎᐏᐐᐑᐒᐓᐔᐕᐖᐗᐘᐙᐚᐛᐜᐝᐞᐟᐠᐡᐢᐣᐤᐥᐦᐧᐨᐩᐪᐫᐬᐭᐮᐯᐰᐱᐲᐳᐴᐵᐶᐷᐸᐹᐺᐻᐼᐽᐾᐿᑁᑂᑃᑄᑅᑆᑇᑈᑉᑊᑋᑌᑍᑎᑏᑐᑑᑒᑓᑔᑕᑖᑗᑘᑙᑚᑛᑜᑝᑞᑟᑠᑡᑢᑣᑤᑥᑦᑧᑨᑩᑪᑫᑬᑭᑮᑯᑰᑱᑲᑳᑴᑵᑶᑷᑸᑹᑺᑻᑼᑽᑾᑿᒀᒁᒂᒃᒄᒅᒆᒇᒈᒉᒊᒋᒌᒍᒎᒏᒐᒑᒒᒓᒔᒕᒖᒗᒘᒙᒚᒛᒜᒝᒞᒟᒠᒡᒢᒣᒤᒥᒦᒧᒨᒩᒪᒫᒬᒭᒮᒯᒰᒱᒲᒳᒴᒵᒶᒷᒸᒹᒺᒻᒼᒽᒾᒿᓀᓁᓂᓃᓄᓅᓆᓇᓈᓉᓊᓋᓌᓍᓎᓏᓐᓑᓒᓓᓔᓕᓖᓗᓘᓙᓚᓛᓜᓝᓞᓟᓠᓡᓢᓣᓤᓨᓩᓪᓫᓬᓭᓮᓯᓰᓱᓲᓳᓴᓵᓶᓷᓸᓹᓺᓻᓼᓽᓾᓿᔀᔁᔂᔃᔄᔅᔆᔇᔈᔉᔊᔋᔌᔍᔎᔏᔐᔑᔒᔓᔔᔕᔖᔗᔘᔙᔚᔛᔜᔝᔞᔟᔠᔡᔢᔣᔤᔥᔦᔧᔨᔩᔪᔫᔬᔭᔮᔯᔰᔱᔲᔳᔴᔵᔶᔷᔸᔹᔺᔻᔼᔽᔾᔿᕀᕁᕂᕃᕄᕅᕆᕇᕈᕉᕊᕋᕌᕍᕎᕏᕐᕑᕒᕓᕔᕕᕖᕗᕘᕙᕚᕛᕜᕝᕞᕟᕠᕡᕢᕣᕤᕥᕦᕧᕨᕩᕪᕫᕬᕭᕱᕲᕳᕴᕵᕶᕷᕸᕹᕺᕻᕼᕽᕾᕿᖀᖁᖂᖃᖄᖅᖆᖇᖈᖉᖊᖋᖌᖍᖎᖏᖐᖑᖒᖓᖔᖕᖖᖗᖘᖙᖚᖛᖜᖝᖞᖟᖠᖡᖢᖣᖤᖥᖦᖧᖨᖩᖪᖫᖬᖭᖮᖯᖰᖱᖲᖳᖴᖵᖶᖷᖸᖹᖺᖻᖼᖽᖾᖿᗀᗁᗂᗃᗄᗅᗆᗇᗈᗉᗊᗋᗌᗍᗎᗏᗐᗑᗒᗓᗔᗕᗖᗗᗘᗙᗚᗛᗜᗝᗠᗡᗢᗣᗤᗥᗦᗧᗨᗩᗪᗫᗬᗭᗮᗰᗱᗲᗳᗴᗵᗶᗷᗸᗹᗺᗻᗼᗽᗾᗿᘀᘁᘂᘃᘄᘅᘆᘇᘈᘉᘊᘋᘌᘍᘎᘏᘐᘑᘒᘓᘔᘕᘖᘗᘘᘙᘚᘛᘜᘠᘡᘢᘣᘤᘥᘦᘧᘨᘩᘪᘫᘬᘭᘮᘯᘰᘱᘲᘳᘴᘵᘶᘷᘸᘹᘺᘻᘼᘽᘾᘿᙀᙁᙂᙃᙄᙅᙆᙇᙈᙉᙊᙋᙌᙍᙎᙏᙐᙑᙒᙓᙔᙕᙖᙗᙘᙙᙚᙛᙜᙝᙞᙟᙠᙡᙢᙣᙤᙥᙦᙧᙨᙩᙪᙫᙬ᙭᙮ᙯᙰᙱᙲᙳᙴᙵᙶᙷᙸᙹᙺᙻᙼᙽᙾᙿ¶")
bases = 10 + len(alphabet)
base_x_results = []
base_x_len = []
base = 0
print("Starting")
for base in range(2, bases + 1):
    if base % 100 == 0:
        print(f"{base} / {bases}")
    #very_input_num = [4, 1, 0]
    very_input_num = list("3141592653589793238462")
    input_num = very_input_num
    input_base = 10
    output_base = base

    to_break = False
    input_numbers = []
    for i in range(input_base):
        if i < 10:
            input_numbers.append(str(i))
        else:
            input_numbers.append(alphabet[i - 10])
    for i in range(len(very_input_num)):
        if input_num[i] not in input_numbers:
            illegal = input_num[i]
            to_break = True
            break
    if to_break == True:
        print(f"{illegal} not in base {input_base}\n Valid numbers: {input_numbers}")
        break


    finished = False
    output_numbers = []
    decimal_num = 0
    for k in range(len(input_num)):
        i = len(input_num) - k - 1
        if input_num[i] not in alphabet:
            decimal_num += int(input_num[i]) * (input_base**k)
        else:
            decimal_num += (10 + alphabet.index(input_num[i])) * (input_base**k)
        if print_work == True:
            print(f"Units: {decimal_num}")
    input_num = []
    input_num.append(decimal_num)
    for i in range(precision):
        input_num.append("0")
    input_num.reverse()         
            
    for i in range(output_base):
        if i < 10:
            output_numbers.append(i)
        else:
            output_numbers.append(alphabet[i - 10])
            
    num = 0
    input_num_list = []
    for i in range(len(input_num)):
        input_num_list.append(int(input_num[i]))
        
    if output_base == 1:
        for i in range(decimal_num):   
            input_num_list.append("1")
            finished = True
            
    if finished == False:
        first = True
        carry = 0
        if print_work == True:
            print(input_num_list, carry)
        for k in range(len(input_num_list)):
            i = len(input_num_list) - k - 1
            if carry > 0:
                carry = math.floor(carry)
                if print_work == True:
                    print(f"carrying {carry} times")
                if print_work == True:
                    for n in range(carry):
                        input_num_list[i] += 1 # for show
                        print(input_num_list, n)
                else:
                    input_num_list[i] += carry
            carry = 0
            if input_num_list[i] >= output_base:
                carry = D(input_num_list[i]) / D(output_base)
                remainder = input_num_list[i] % output_base
                input_num_list[i] = remainder
        for i in range(len(input_num_list)):
            if input_num_list[i] > 9:
                input_num_list[i] = alphabet[input_num_list[i] - 10]
    temp = []
    if output_base == 1:
        string_in_num = []
        for i in range(len(very_input_num)):
            string_in_num.append(str(very_input_num[i]))
        string_in_num = "".join(string_in_num)
        input_num_list.remove(int(string_in_num))
    for i in range(len(input_num_list)):
        temp.append(str(input_num_list[i]))
    out_num = temp[:]
    for i in range(len(temp)):
        if temp[i] == "0":
            out_num.remove("0")
        else:
            break
    temp = very_input_num[:]
    for i in range(len(temp)):
        if temp[i] == "0":
            very_input_num.remove("0")
        else:
            break
    temp = very_input_num[:]
    for i in range(len(temp)):
        very_input_num[i] = str(very_input_num[i])
    out_num_comma = ",".join(out_num)
    very_input_num_comma = ",".join(very_input_num) 
    out_num = "".join(out_num)
    very_input_num = "".join(very_input_num)
    if bases < 1:
        print(f"\nInput in Base {input_base}: {very_input_num_comma}")
        print(f"Output in Base {output_base}: {out_num_comma}")
        print(f"\nInput in Base {input_base}: {very_input_num}")
        print(f"Output in Base {output_base}: {out_num}")
    else:
        if base % 1000 == 0:
            print("Base", base, "/", bases)
    base_x_results.append(out_num)
    base_x_len.append(len(out_num))
print()
xpoints = []
ypoints = []
exclude_graph_list = [1]
starter = len(list(f"Base {2}: length of {base_x_len[0]} | {base_x_results[0]}"))
print(f"{very_input_num} (base {input_base}) in:")
for i in range(len(base_x_results)):
    filler = []
    for filler_index in range(starter - (len(list(f"Base {i+2}: length of {base_x_len[i]} | {base_x_results[i]}"))) + 1):
        filler.append(" ")
    filler = "".join(filler)
    if do_filler == False:
        filler = " "
    print(f"Base {i+2}: length of {base_x_len[i]} |{filler}{base_x_results[i]}")
    if i + 1 not in exclude_graph_list:
        xpoints.append(i + 1)
        ypoints.append(base_x_len[i - 1]) # I don't know how -1 works but it does
X_Y_Spline = make_interp_spline(xpoints, ypoints)
X_ = np.linspace(min(xpoints), max(xpoints), int(bases/50))
Y_ = X_Y_Spline(X_)
plt.plot(X_, Y_, ls = ":", color = "orange")
plt.axhline(y=len(very_input_num), ls = ":", color = "r") # plot line of efficiency of input base
plt.axhline(y=base_x_len[-1], ls = ":", color = "black")
plt.axvline(x=2, ls = ":", color = "black")
x, y = [2], [base_x_len[0]]
for i in range(1, base_x_len[0] * 1000):
    x.append(i + 2) # plot relative y = 1/x for comparison
    y.append((base_x_len[0]/(i + 1)) + base_x_len[-1])
plt.plot(x, y, ls = "--", color = "magenta")
plt.plot(input_base, len(very_input_num), marker = "o", color = "r")
plt.title("Efficiency of n in different bases")
plt.xlabel("Base")
plt.ylabel("Length")
plt.xlim(0, bases - 1)
plt.ylim(0) # zoom in on the actual graph, not extra lines
plt.grid()
plt.plot(xpoints, ypoints)
plt.show() # graph on high amounts looks like graph (y = 1/x)
useless = input()